<?php

//Directory Separator
defined('DS') ? null : define('DS',DIRECTORY_SEPARATOR);
defined('WHMCS6') or define('WHMCS6', isset($GLOBALS['CONFIG']['Version']) && $GLOBALS['CONFIG']['Version'] >= '6.0.0');

//Init (Autoload and Other stuff)
require_once dirname(__FILE__).DS.'init.php';

include dirname(__FILE__) . DS . 'libraries' . DS . 'classes' . DS . 'class.MG_DB.php';

/**
 * Just change function name. Do not edit anything more.
 */
function ServerAllocator_config()
{
    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //Return Configuration
    return array
    (
        'name'          =>  $MGC->system_name,
        'description'   =>  $MGC->description,
        'version'       =>  $MGC->version,
        'author'        =>  $MGC->author,
        'fields'        =>  $MGC->config(),
    );
}

function ServerAllocator_activate()
{
    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //Run Activate Command
    return $MGC->activate();
}

function ServerAllocator_deactivate()
{
    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //Run deactivate Command
    $MGC->deactivate();
}


function ServerAllocator_upgrade($vars)
{
    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //Run Upgrade Command
    $MGC->upgrade($vars);
}





/**
 * Admin area output
 * @param type $vars
 */
function ServerAllocator_output($vars)
{
    

    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //Load Addon Core
    require_once dirname(__FILE__).DS.'core'.DS.'core.php';
}

function ServerAllocator_clientarea($vars)
{
    

    //Load Config File
    require_once dirname(__FILE__).DS.'config.php';
    //Get Addon Name
    $module = basename(__FILE__, '.php');
    //Create Module Config Class
    $MGC = new $module();
    //We need to put content in template oO
    ob_start();
    require_once dirname(__FILE__).DS.'core'.DS.'core.php';
    $content = ob_get_clean();

    return array(
        'pagetitle'     => 'addon',
        'breadcrumb'	=> array('index.php?m=ServerAllocator' => 'Server Allocator'),
        'templatefile'	=> 'core/base',
        'requirelogin'	=> isset($_SESSION['uid']) ? false : true,
        'vars' => array(
            'content'	=> $content,
        ),
    );

}
