<?php

use MGModule\ServerAllocator\libraries\classes\MG_ErrorException;

//Define Addon Dir
$ADDON_DIR = substr(dirname(__FILE__), 0, strrpos(dirname(__FILE__), 'core'));

//Get Addon Name
$ADDON_NAME = basename(substr(dirname(__FILE__), 0, strrpos(dirname(__FILE__), 'core')));

//Assets Dir
$ASSETS_DIR = '';

//Module URL
$MODULE_URL = 'addonmodules.php?module='.$_GET['module'];

//Is Client Area?
$IS_CLIENT_AREA = false;

if(basename($_SERVER['PHP_SELF'], '.php') == 'index' && isset($_REQUEST['m']))
{
    $IS_CLIENT_AREA = true;
}

//Get Controller And Method
$CONTROLLER_NAME    =   $_REQUEST['modpage'] ? preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST['modpage']) : '';
$METHOD_NAME        =   $_REQUEST['modsubpage'] ? preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST['modsubpage']) : '';

//Set Default Controller
if($CONTROLLER_NAME == '')
{
    $CONTROLLER_NAME    =   $IS_CLIENT_AREA ? $MGC->default_client_controller : $MGC->default_admin_controller;
}

//Set Default Method
if($METHOD_NAME == '')
{
    $METHOD_NAME        =   $IS_CLIENT_AREA ? $MGC->default_client_method : $MGC->default_admin_method;
    if($METHOD_NAME == '')
    {
        $METHOD_NAME = 'index';
    }
}

$moddir = '';
if($IS_CLIENT_AREA)
{
    $moddir     =   $ADDON_DIR.'clientarea'.DS;
    $ASSETS_DIR =   'modules'.DS.'addons'.DS.$ADDON_NAME.DS.'core'.DS.'assets';
}
else
{
    $moddir     =   $ADDON_DIR.'adminarea'.DS;
    $ASSETS_DIR =   '..'.DS.'modules'.DS.'addons'.DS.$ADDON_NAME.DS.'core'.DS.'assets';
}

//Start Buffering
ob_start();

//Controller object
$CONTROLLER = null;

//Try to load our controller
try
{
    //Do not call "private" methods
    if(strpos($METHOD_NAME, '_') === 0)
    {
       throw new Exception('Cannot run this function!'); 
    }
    
    if(!file_exists($moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php'))
    {
        throw new Exception('Cannot locate controller file.'. $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php'); 
    }
    
    require_once $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php';
    
    if(!class_exists($CONTROLLER_NAME))
    {
        throw new Exception('Cannot locate class '.$CONTROLLER_NAME.' in '.$moddir.DS.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');
    }
    
    if(!method_exists($CONTROLLER_NAME, $METHOD_NAME))
    {
        throw new Exception('Cannot call method '.$METHOD_NAME.'. Method doest not exists in class '.$CONTROLLER_NAME.' in '.$moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');
    }
 
    //Create Controller Class
    $CONTROLLER = new $CONTROLLER_NAME();
    //Run init
    $CONTROLLER->_init($ADDON_NAME, $moddir.$CONTROLLER_NAME.DS.$CONTROLLER_NAME.'.php');

    $CONTROLLER->$METHOD_NAME();
}
//Catch error exception.
catch(MG_ErrorException $ex)
{
    $_SESSION[$ADDON_NAME]['messages'][] = array
    (
        'type'  =>  'danger',
        'msg'   =>  $ex->getMessage()
    ); 
}
catch(Exception $ex)
{
    if(empty($_SESSION['adminid']))
    {
        $PAGE_SUBMODULE_HEADING = 'Error Occurred. Please Contact With Support';
         
        ob_get_clean();
        ob_start();
        $error = array
        (
            'message'   =>  $ex->getMessage(),
            'code'      =>  $ex->getCode(),
            'file'      =>  $ex->getFile(),
            'trace'     =>  $ex->getTraceAsString()
        );
        
        $error = base64_encode(serialize($error));
        
        require_once $ADDON_DIR.DS.'core'.DS.'errors'.DS.'error.php';
    }
    else
    {
        $_SESSION[$ADDON_NAME]['messages'][] = array
        (
            'type'  =>  'danger',
            'msg'   =>  'Error Occurred. Please Contact With Support.<br /> '.$ex->getMessage()
        ); 
    }
}

//Get Content
$CONTENT = ob_get_clean();
    
//Get Addon Messages;
$MESSAGES = $_SESSION[$ADDON_NAME]['messages'];
$_SESSION[$ADDON_NAME]['messages']  =   null;
   
//Is JSON output?
if(isset($CONTROLLER) && $CONTROLLER->isJSON())
{
    ob_clean();
    header('Content-Type: application/json');
    echo $CONTENT;
    ob_end_flush();
    exit;
}
//Is Ajax?
elseif(isset($CONTROLLER) && $CONTROLLER->isAjax())
{
    ob_clean(); 
    include dirname(__FILE__).DS.'ajax_output.php';
    ob_end_flush();
    exit;
}
//Client Area
elseif($IS_CLIENT_AREA)
{
        include dirname(__FILE__).DS.'output_client.php';
}
//Admin Area
else
{
    include dirname(__FILE__).DS.'output.php';
}