<?php
namespace MGModule\ServerAllocator\libraries\classes;

use MGModule\ServerAllocator\libraries\classes as classes;
class CheckProductsRules
{
    public function execute($productid)
    {
        $product = classes\GetDataFromDB::getProduct($productid);

        $pgid = $product['pgid'];

        $rulegroup = classes\GetDataFromDB::getRuleGroup($pgid);
        $rules = classes\GetDataFromDB::getRules($pgid);
        
        if(empty($rules))
        {
            return;
        }
        $rulespassed = $this->checkRulePassed($rules, $productid, $product['userid']);
        
        $this->update($rulespassed, $product, $productid, $rulegroup);
    }

    
    private function checkRulePassed($rules, $productid, $userid)
    {
        $rulespassed = [];

        foreach($rules as $rule)
        {
            $checkFields = new classes\CheckFields();
            $rulespassed[] = $checkFields->checkParamsAndReturnPriority($rule, $productid, null, null, null, null, $userid);
        }
        
        $rulespassed = classes\CheckFields::sortByPriority($rulespassed, 'priority', SORT_DESC);
        
        return $rulespassed;
    }

    private function update($rulespassed, $product, $productid, $rulegroup)
    {
        foreach($rulespassed as $rule) {    
            if(!empty($rule))
            {
                $update = new classes\Updatetblhosting();
                $update->updateByRulePassed($rulespassed, $product, $productid);
                break;
            } 
            else 
            {
                $update = new classes\Updatetblhosting();
                $update->updateByDefault($rulegroup, $product, $productid);
                break;
            }
        }
    }
}