<?php
namespace MGModule\ServerAllocator\libraries\classes;

use MGModule\ServerAllocator\libraries\classes as classes;

class CheckShoppingProdctsRules
{

    public function execute($products)
    {
        $lang = new classes\MG_Lang(dirname(__FILE__).DIRECTORY_SEPARATOR.'lang');
        $lang = $lang->getLang();

        $product = classes\GetDataFromDB::getProductForShoppingCartValidate($products['pid']);
        $productGroup = classes\GetDataFromDB::getProductGroup($product['gid']);       
        $ruleGroup = classes\GetDataFromDB::getRuleGroup($productGroup['id']);
        $rules = classes\GetDataFromDB::getRules($productGroup['id']);

        $outPutData = $this->getOutPutData($products);

        if (empty($rules)) 
        {
            return;
        }

        $rulespassed = array();
        foreach ($rules as $rule) {
            $checkFields = new classes\CheckFields();
            $passed = $checkFields->checkParamsAndReturnPriority($rule, $products['pid'], $outPutData['outputConfigOptions'], $outPutData['outputAddons'], $outPutData['outputFields'], $outPutData['outputclient']);
            $rulespassed[] = $passed;
            $fullserver =  $passed['0']['fullserver'];
        }
        classes\CheckFields::sortByPriority($rulespassed, 'priority', SORT_ASC);
        
        $this->update($fullserver, $product, $ruleGroup, $rulespassed, $lang);
    }

    private function getOutPutData($products)
    {
        $outPutData = [];

        $outPutData = [
            'outputConfigOptions' => $this->selectConfigOption($products),
            'outputAddons' => $this->selectAddos($products),
            'outputFields' => $this->selectCustomFields($products),
            'outputclient' => classes\GetDataFromDB::getClient($_SESSION['uid'])
        ];

        return $outPutData;
    }

    private function selectCustomFields($products)
    {
        $customFields = $products['customfields'];
        foreach ($customFields as $customFieldId => $customFieldValue) {
            $field = classes\GetDataFromDB::getField($customFieldId);
            $outputFields[] = [
                'fieldid' => $customFieldId,
                'fieldtype' => $field['fieldtype'],
                'value' => $customFieldValue
            ];
        }
        return $outputFields;
    }

    private function selectAddos($products)
    {
        $addons = $products['addons'];
        foreach ($addons as $index => $addonId) {
            $outputAddons[] = [
                'addonid' => $addonId
            ];
        }
        return $outputAddons;
    }
    
    private function selectConfigOption($products)
    {
        $configOptions = $products['configoptions'];
        foreach ($configOptions as $configOptionId => $configOption) {
            $option = classes\GetDataFromDB::getOptions($configOptionId);
            
            switch ($option['optiontype']) {
                case "1": //dropdowns
                    $outputConfigOptions[] = [
                        'id' => null,
                        'relid' => null,
                        'configid' => $configOptionId,
                        'optionid' => $configOption,
                        'qty' => 0
                    ];
                    break;
                case "2": //radio
                    $outputConfigOptions[] = [
                        'id' => null,
                        'relid' => null,
                        'configid' => $configOptionId,
                        'optionid' => $configOption,
                        'qty' => 0
                    ];
                    break;
                case "3": // yes/no
                    $outputConfigOptions[] = [
                        'id' => null,
                        'relid' => null,
                        'configid' => $configOptionId,
                        'optionid' => null,
                        'qty' => $configOption
                    ];
                    break;
                case "4": // Quantity
                    $outputConfigOptions[] = [
                        'id' => null,
                        'relid' => null,
                        'configid' => $configOptionId,
                        'optionid' => null,
                        'qty' => $configOption
                    ];
                    break;
                default:
                    break;
            }
        }

        return $outputConfigOptions;
    }
    
    // private function select
    private function update($fullserver, $product, $ruleGroup, $rulespassed, $lang)
    {
        if (!empty($rulespassed)) {
            $this->allocateServer($rulespassed, $product, $fullserver, $lang, $ruleGroup);
        } else {
            $needDefault = true;
        }

        if ($needDefault) {
            $this->needDefault($ruleGroup, $product, $fullserver, $lang);
        }
    }

    private function allocateServer($rulespassed, $product, $fullserver, $lang, $ruleGroup)
    {
        $rulesCounter = 0;
        $rulesSum = count($rulespassed);
        $lastServer = null; 

        foreach ($rulespassed as $rulepassed) {
            $servers = classes\GetDataFromDB::getServers($rulepassed['rule'], $product['servertype']);

            $allocatedServer = serverallocatorAllocateServer($servers, $rulepassed['filltype']);
            $rulesCounter++;

            if (!empty($allocatedServer['serverid'])) {
                $lastServer = $allocatedServer;      
            }

            if($rulesCounter == $rulesSum){
                $this->checkServerUsage($lastServer, $fullserver,$lang);
            } 

            if (empty($allocatedServer['serverid'])) {
                $this->needDefault($ruleGroup, $product, $fullserver, $lang);     
            }
        }
    }

    private function checkServerUsage($lastServer, $fullserver,$lang)
    {
        if ($lastServer['usage'] >= $lastServer['maxaccounts'] && $fullserver) {
            return [
                $lang['fullservererror']
            ];
        }
    }
    
    private function needDefault($ruleGroup, $product, $fullserver, $lang)
    {
        $dservers  = unserialize($ruleGroup['defaultservers']);
        if(empty($dservers) || !is_array($dservers))
        {
            return [];
        }

        $dserversq = implode(",", $dservers);

        if ($dserversq) {
            $dserver = classes\GetDataFromDB::getServerId($product['servertype'], $dserversq);
        }

        if ($dserver['usage'] >= $dserver['maxaccounts'] && $fullserver) {
            return [
                $lang['fullservererror']
            ];
        }
    }

}
