<?php

namespace MGModule\ServerAllocator\libraries\classes;
use MGModule\ServerAllocator\libraries\classes as classes;

/**********************************************************************
 *  DirectVPS (2013-09-13)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 **********************************************************************/


/**
 * @author Grzegorz Draganik <grzegorz@modulesgarden.com>
 * @author Mariusz Miodowski <mariusz@modulesgarden.com>
 */


class MG_Hosting 
{
    //Hosting ID
    public $id = 0;
    //product Detaild
    public $product_details = array();
    //custom fields
    public $custom_fields = array();
    //configurable options
    public $configurable_options = array();
    //server configuration
    public $server_details = array();
    
    public function __construct($id)
    {
        $this->id = $id;
        
        //Load Hosting Params
        $this->load();
    }
	
    public function updateDetails(array $values)
    {
        $sets = array();
        foreach ($values as $key => $value)
        {
            $value = is_numeric($value) ? $value : '"'.classes\PDOWrapper::real_escape_string($value).'"';
            $sets[] = $key.'='.$value;
        }
        
        return classes\PDOWrapper::query('UPDATE tblhosting SET '.implode(',',$sets).' WHERE id = ' . (int)$this->id);
    }
    
    public function load()
    {
        //Get Hosting Details
        $q  = classes\PDOWrapper::get_row("SELECT * FROM tblhosting WHERE id = ?", array($this->id));
        foreach($q as $key => &$val)
        {
            $this->hosting_details[$key]    =   $val;
        }
        $this->hosting_details['password']  =   decrypt($this->hosting_details['password']);
        
        //Get Custom fields
        $q = classes\PDOWrapper::get_array('SELECT cf.id, cf.fieldname, cfv.value
                    FROM tblcustomfields AS cf
                    JOIN tblcustomfieldsvalues AS cfv ON cfv.fieldid = cf.id
                    WHERE cf.type = "product" AND cfv.relid = '.(int)$this->id.'');
        foreach($q as $key  =>  &$val)
        {
            if(strpos($val['fieldname'], '|'))
            {
                $this->custom_fields[substr($val['fieldname'], 0, strpos($val['fieldname'], '|'))]  =   $val['value'];
            }
            else
            {
                $this->custom_fields[$val['fieldname']]  =   $val['value'];
            }
        }
        
        //Get Server Configuration
        if($this->hosting_details['server'])
        {
            $q = classes\PDOWrapper::get_row("SELECT * FROM tblservers WHERE id = ?", array($this->hosting_details['server']));
            foreach($q as $key => &$val)
            {
                $this->server_details[$key]    =   $val;
            }
        }
    }
    
    /********************************
     *          GETTERS
     *******************************/
    
    /**
     * Get Hosting Details
     * @param type $key
     * @return boolean
     */
    public function getDetails($key = null)
    {
        if(isset($this->hosting_details[$key]))
        {
            return $this->hosting_details[$key];
        }
        
        return false;
    }
    
    /**
     * Get Custom Field
     * @param type $key
     * @return boolean
     */
    public function getCustomField($key)
    {
        if(isset($this->custom_fields[$key]))
        {
            return $this->custom_fields[$key];
        }   
        
        return false;
    }
    
    
    /*******************************
     *           SETTERS
     ******************************/
    
    public function setDetails($setting, $value)
    {
        
    }
    
    /**
     * Set Custom Field
     * @param type $fieldname
     * @param type $value
     */
    public function setCustomField($fieldname, $value)
    {
        $q = classes\PDOWrapper::query("UPDATE tblcustomfields f
            LEFT JOIN tblcustomfieldsvalues v ON f.id = v.fieldid
            SET v.value = ?
            WHERE v.relid = ? AND (f.fieldname = ? OR f.fieldname LIKE ?)", array(
                $value,
                $this->id,
                $fieldname,
                $fieldname.'|%'
            ));
    }
}