<?php

namespace MGModule\ServerAllocator\libraries\classes;
use MGModule\ServerAllocator\libraries\classes as classes;

/* * ********************************************************************
 * Customization Services by ModulesGarden.com
 * Copyright (c) ModulesGarden, INBS Group Brand, All Rights Reserved 
 * (2013-06-18, 11:19:35)
 * 
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

/**
 * @author Grzegorz Draganik <grzegorz@modulesgarden.com>
 * @modified Mariusz Miodowski <mariusz@modulesgarden.com>
 */

class MG_Product
{	
    //Product ID
    public $id;
    //Product Configuration. Should be created in child
    public $defaultConfig   = array();
    //Default table
    protected $_tableName   = '';
    
    protected $_config      = null;

    public function __construct($id, array $params = array())
    {
        //Get child name
        $child              =   get_class($this);
        
        //Set up default table name
        $this->_tableName   =   'mg_'.$child;
        
        //Copy Params
        foreach ($params as $k => $v)
        {
                $this->$k = $v;
        }
        $this->id = (int)$id;
    }
	
    
    public function runAutoConfiguration()
    {
        //Generate Custom Fields
        if($_REQUEST['modaction']  ==  'generate_custom_fields')
        {
            ob_clean();
            $ret = $this->generateDefaultCustomField();
            $json = array();
            if($ret)
            {
                $json['status']     =   1;
                $json['message']    =   'Custom Fields Generated';   
            }
            else
            {
                $json['status']     =   0;
                $json['message']    =   'Custom Fields Already Generated'; 
            }
            
            echo json_encode($json);
            die();
        }
        //Generate Configurable Options
        elseif($_REQUEST['modaction']  ==  'generate_configurable_options')
        {
            ob_clean();
            $ret = $this->generateDefaultConfigurableOptions();
            $json = array();
            if($ret)
            {
                $json['status']     =   1;
                $json['message']    =   'Configurable Options Generated';   
            }
            else
            {
                $json['status']     =   0;
                $json['message']    =   'Configurable Options Already Generated'; 
            } 
            
            echo json_encode($json);
            die();
        }
    }
    /**
     *  Save Product Configuration
     * @param type $customconfigoption
     */
    public function saveConfigOptions($customconfigoption)
    { 
        $this->clearConfig();
        
        foreach ($customconfigoption as $k => $v)
        {
            $this->saveConfig($k, $v);
        }
    }
    
    /**
     *  Generate Default Custom Fieds
     * @return boolean
     */
    public function generateDefaultCustomField()
    {
        foreach($this->defaultCustomField as $key => $field)
        {
            $q  = classes\PDOWrapper::query("SELECT id, relid, fieldname
			FROM tblcustomfields
			WHERE
				relid = ".$this->id."
				AND type = 'product'
				AND (fieldname = '".$key."' OR fieldname LIKE '".$key."|%') ");

            if(classes\PDOWrapper::num_rows($q))
            {
                return false;
            }
            
            switch($field['type'])
            {
                case 'text':
                    classes\PDOWrapper::query('INSERT INTO tblcustomfields(type,relid,fieldname,fieldtype,description,fieldoptions,regexpr,adminonly,required,showorder,showinvoice,sortorder)
			VALUES("product", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)', array(
                            $this->id,
                            $key.'|'.$field['title'],
                            "text",
                            $field['description'] ? $field['description'] : '',
                            $field['fieldoptions'] ? $field['fieldoptions'] : '',
                            $field['regexpr'] ? $field['regexpr'] : '',
                            $field['adminonly'] ? 'on' : '',
                            $field['required']  ? 'on' : '',
                            $field['showorder'] ? 'on' : '',
                            $field['showinvoice'] ? 'on' : '',
                            $field['sortorder']   ?' on' : ''
                        ));
                    break;
                    case 'quantity':
                            classes\PDOWrapper::query('INSERT INTO tblproductconfigoptions(gid,optionname,optiontype,qtyminimum,qtymaximum,`order`,hidden) VALUES(?,?,4,?,?,0,0)', array(
                                $group_id,
                                $field_key.'|'.$field['title'],
                                $field['min'],
                                $field['max'],
                            ));
                    break;
                default:
                    die('Unsupported type!');
            }
        }
        
        return true;
    }
    
    /**
     * Generate Default Configurable Options
     */
    public function generateDefaultConfigurableOptions()
    {
        if($this->hasConfigurableOptions())
        {
            return false;
        }
        
        foreach($this->defaultConfigurableOptions as $group)
        {
            //Create Group
            classes\PDOWrapper::query('INSERT INTO tblproductconfiggroups(name,description) VALUES(?, ?)', array(
                $group['title'],
                $group['description']
            ));
            $group_id = classes\PDOWrapper::insert_id();
            
            //Assign to product
            classes\PDOWrapper::query('INSERT INTO tblproductconfiglinks(gid,pid) VALUES(?,?)', array($group_id, $this->id));
                            
            
            foreach($group['fields'] as $field_key => $field)
            {
                //Insert configurable options
                $field_id   = classes\PDOWrapper::insert_id();
                
                switch($field['type'])
                {
                    case 'select':
                        classes\PDOWrapper::query('INSERT INTO tblproductconfigoptions(gid,optionname,optiontype,qtyminimum,qtymaximum,`order`,hidden) VALUES(?,?,1,0,0,0,0)', array(
                            $group_id,
                            $field_key.'|'.$field['title']
                        ));
                        break;
                    default:
                        die('Unsupported type!');
                }
                
                $config_id   = classes\PDOWrapper::insert_id();
                
                //Insert options
                foreach($field['options'] as $option_key => $option)
                {
                        switch($field['type'])
                        {
                            case 'select':
                                classes\PDOWrapper::query("INSERT INTO tblproductconfigoptionssub(configid,optionname,sortorder,hidden) VALUES(?,?,0,0)", array
                                    (
                                        $config_id,
                                        $option['value'].'|'.$option['title'],
                                        (int)$option['sortorder'],
                                        $option['hidden'] ? 'on' : ''
                                    ));
                                break;
                            case 'quantity':
                                classes\PDOWrapper::query("INSERT INTO tblproductconfigoptionssub(configid,optionname,sortorder,hidden) VALUES(?,?,0,0)", array
                                    (
                                        $config_id,
                                        1,
                                        (int)$option['sortorder'],
                                        $option['hidden'] ? 'on' : ''
                                    ));
                                break;
                        }
                }
            }
        }
        
        return true;
    }
    
    /**
     * Load Product Configuration
     * @throws Exception
     */
    public function load()
    {
        $q = classes\PDOWrapper::query('SELECT * FROM tblproducts WHERE id = ' . (int)$this->id);
        $row = classes\PDOWrapper::fetch_assoc($q);
        if (!empty($row))
        {
            foreach ($row as $k => $v)
            {
                $this->$k = $v;
            }
        }
        else
        {
            throw new \Exception('No product to load');
        }
    }
    
    /**
     *  Load product configuration by service it
     * @param type $serviceid
     */
    public function setIdByServiceId($serviceid)
    {
        $q = classes\PDOWrapper::query('SELECT packageid FROM tblhosting WHERE id = ' . (int)$serviceid);
        $row = classes\PDOWrapper::fetch_assoc($q);
        $this->id = (int)$row['packageid'];
    }
	
    /**
     * Update product details
     * @param array $values
     * @return type
     */
    public function update(array $values)
    {
        $sets = array();
        foreach ($values as $k => $v)
        {
                $v = is_numeric($v) ? $v : '"'.classes\PDOWrapper::real_escape_string($v).'"';
                $sets[] = $k.'='.$v;
        }
        return classes\PDOWrapper::query('UPDATE tblproducts SET '.implode(',',$sets).' WHERE id = ' . (int)$this->id);
    }
    
    /**
     * Has Configurable Options?
     * @return type
     */
    public function hasConfigurableOptions()
    {
            $q = classes\PDOWrapper::query('SELECT * FROM tblproductconfiglinks WHERE pid = ?', array($this->id));
            return (bool)classes\PDOWrapper::num_rows($q);
    }

    /**
     * 
     * @return type
     */
    public function hasAssignedServerGroup()
    {
            $q = classes\PDOWrapper::query('SELECT servergroup FROM tblproducts WHERE id = ?', array($this->id));
            $row = classes\PDOWrapper::fetch_assoc($q);
            return isset($row['servergroup']) ? (int)$row['servergroup'] : false;
    }
	
    
    /**
     * 
     * @return type
     */
    public function getParams()
    {
            $result = classes\PDOWrapper::query("
                    SELECT
                            s.ipaddress AS serverip, s.hostname AS serverhostname, s.username AS serverusername, s.password AS serverpassword,
                            configoption1,configoption2,configoption3,configoption4,configoption5,configoption6,configoption7,configoption8,configoption9
                    FROM tblservers AS s
                    JOIN tblservergroupsrel AS sgr ON sgr.serverid = s.id
                    JOIN tblservergroups AS sg ON sgr.groupid = sg.id
                    JOIN tblproducts AS p ON p.servergroup = sg.id
                    WHERE p.id = ?
                    ORDER BY s.active DESC
                    LIMIT 1",
                    array($this->id)
            );
            $row = classes\PDOWrapper::fetch_assoc($result);
            // old whmcs
            if (!function_exists('decrypt') && file_exists(ROOTDIR . DS . 'includes' . DS . 'functions.php'))
                    include_once ROOTDIR . DS . 'includes' . DS . 'functions.php';
                    if(!empty($row['serverpassword']))
                        $row['serverpassword'] = \decrypt($row['serverpassword']);
            return $row;
    }
		
		// ========================================
		// ============ CUSTOM CONFIG =============
		// ========================================
		
		public function getConfig($name)
                {
			$this->loadConfig();
			return isset($this->_config[$name]) ? $this->_config[$name] : null;
		}
		
		public function issetConfig($name){
			$this->loadConfig();
			return isset($this->_config[$name]);
		}

		public function loadConfig(){
			if ($this->_config !== null)
				return $this->_config;

			$this->setupDbTable();
			$q = classes\PDOWrapper::query('SELECT * FROM '.$this->_tableName.' WHERE product_id = ' . (int)$this->id);
			while ($row = classes\PDOWrapper::fetch_assoc($q)){
                                if(json_decode($row['value'])!== NULL)
                                    $row['value'] = json_decode ($row['value']);
                                
				$this->_config[$row['setting']] = $row['value'];
			}
			return $this->_config;
		}

		public function saveConfig($name, $value){
			$this->setupDbTable();
                        if(is_array($value))
                            $value = json_encode($value);
			return classes\PDOWrapper::query('INSERT INTO '.$this->_tableName.'(setting,product_id,value) VALUES(?,?,?) ON DUPLICATE KEY UPDATE value = ?', array(
				$name,
				(int)$this->id,
				($value=='-- not specified --' ? '' : $value),
				$value
			));
		}
		
		public function clearConfig(){
			return classes\PDOWrapper::query('DELETE FROM '.$this->_tableName.' WHERE product_id = ' . (int)$this->id);
		}
		
		public function renderConfigOptions($scripts = ''){
			$scripts .= '
				<style type="text/css">
				td.configoption_group {background-color:silver;font-weight:bold;text-align:left;}
				.fieldlabel.mg, .fieldarea.mg {width:25%;}
				.fielddescription {font-size: 10px;color: gray;display: inline;}
				</style>
			';
                        
			$str = '';
			$options = array();
			$groups = array();
			$i = 0;
			foreach ($this->defaultConfig as $k => $config)
                        {
                            // group html
                            if (is_string($config))
                            {
                                    $groups[$i] = $config;
                                    continue;
                            }
                            
                            if($k == 'generate_configurable_options')
                            {
                                $options[] = '
					<td class="fieldlabel mg">Configurable Options</td>
					<td class="fieldarea mg"><a href="#" class="generate_configurable_options">Generate</a></td>';
                                
                                $scripts    .=  '<script type="text/javascript">
                                                    jQuery(function(){
                                                       jQuery(".generate_configurable_options").click(function(event){
                                                            event.preventDefault();
                                                                    jQuery.post(window.location.href, {"modaction":"generate_configurable_options", "productid":'.$this->id.'}, function(res){
                                                                    alert(res.message);
                                                                    if(res.status)
                                                                    {
                                                                        window.location.href = "configproducts.php?action=edit&id='.$this->id.'&tab=4";
                                                                    }
                                                            }, "json");
                                                        });
                                                    });
                                                 </script>';
                                
                                
                            }
                            elseif($k == 'genereate_custom_field')
                            {
                                $options[] = '
					<td class="fieldlabel mg">Custom Field</td>
					<td class="fieldarea mg"><a href="#" class="generate_custom_fields">Generate</a></td>';
                                
                                $scripts    .=  '<script type="text/javascript">
                                                    jQuery(function(){
                                                       jQuery(".generate_custom_fields").click(function(event){
                                                            event.preventDefault();
                                                                    jQuery.post(window.location.href, {"modaction":"generate_custom_fields", "productid":'.$this->id.'}, function(res){
                                                                    alert(res.message);
                                                                    if(res.status)
                                                                    {
                                                                        window.location.href = "configproducts.php?action=edit&id='.$this->id.'&tab=3";
                                                                    }
                                                            }, "json");
                                                        });
                                                    });
                                                 </script>';
                                                                
                            }
                            else 
                            {                           
				$options[] = '
					<td class="fieldlabel mg">'.$config['title'].'</td>
					<td class="fieldarea mg">
						'.$this->renderConfigOptionInput(
							$k,
							$config['type'],
							isset($config['default']) ? $config['default'] : '',
							isset($config['options']) ? $config['options'] : array(),
							isset($config['useOptionsKeys']) && $config['useOptionsKeys']
						) . ($i == 0 ? $scripts : '') . '
						'.(isset($config['description']) ? '<div class="fielddescription">'.$config['description'].'</div>' : '').'
					</td>';
                                $i++;
                            }
			}
			$countFields = 0;
			foreach ($options as $k => $option)
                        {
				if ($countFields == 0 && $k != 0)
					$str .= '<tr>';
				
				if (isset($groups[$k])){
					if ($countFields == 1)
						$str .= '<td></td><td></td>';
					$str .= '</tr><tr><td colspan="4" class="configoption_group">'.$groups[$k].'</td></tr><tr>';
					$countFields = 0;
				}
				$str .= $option;
				
				$countFields++;
				if ($countFields == 2)
					$str .= '</tr>';
				if ($countFields > 1)
					$countFields = 0;
			}
			if ($countFields != 0)
				$str .= '</tr>';
			return $str;
		}
		
		public function renderConfigOptionInput($name, $type, $default, array $options = array(), $optionsValuesFromKeys = false){
			$value = $this->getConfig($name) ? $this->getConfig($name) : ($this->issetConfig($name) ? '' : $default);
			switch ($type){
				case 'multiselect':
					$str = '<select name="customconfigoption['.$name.'][]" multiple style="width:160px;">';
					foreach ($options as $k => $option){
						$str .= '<option value="'.($optionsValuesFromKeys ? $k : $option).'" '.(is_array($value) && in_array(($optionsValuesFromKeys ? $k : $option),$value) ? 'selected' : '').'>'.$option.'</option>';
					}
					$str .= '</select>';
					return $str;
					
				case 'select':
					$str = '<select name="customconfigoption['.$name.']" style="width:160px;">';
					foreach ($options as $k => $option){
						$str .= '<option value="'.($optionsValuesFromKeys ? $k : $option).'" '.($value == ($optionsValuesFromKeys ? $k : $option) ? 'selected' : '').'>'.$option.'</option>';
					}
					$str .= '</select>';
					return $str;
				
				case 'text':
					return '<input type="text" name="customconfigoption['.$name.']" style="width:150px;" value="'.$value.'" />';
					
				case 'textarea':
					return '<textarea name="customconfigoption['.$name.']" style="width:100%">'.$value.'</textarea>';
					
				case 'radio':
					$str = '';
					foreach ($options as $option)
						$str .= '<input type="radio" name="customconfigoption['.$name.']" value="'.$option.'" /> ' . $option;
					return $str;
                                                                        
                                case 'checkbox': 
                                    return '<input type="checkbox"  name="customconfigoption['.$name.']" value="1"  '.($value ? ' checked="checked" ' : '').' /> '.$option;
                                    
                                case 'empty':
                                    return '';
                                    
			}
			// NO CHECKBOX
			throw new \Exception('Config Option type not supported');
		}
		
		public function setupDbTable(){
			return classes\PDOWrapper::query('CREATE TABLE IF NOT EXISTS `'.$this->_tableName.'` (
				`setting` varchar(100) NOT NULL,
				`product_id` int(10) unsigned NOT NULL,
				`value` varchar(250) NOT NULL,
				PRIMARY KEY (`setting`,`product_id`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;');
		}
                
               
                
                
}
	
/**
@EXAMPLE HOOKS.php

add_hook("ProductEdit", 1, "directVPS_ProductEdit");

function directVPS_ProductEdit($params)
{
    if(strtolower($params['servertype']) == 'yourservertype' && $_REQUEST['customconfigoption'])
    {
        //Load MG_Product
        require_once dirname(__FILE__).DIRECTORY_SEPARATOR.'tools'.DS.'class.MG_Product.php';
        //Load Product
        require_once dirname(__FILE__).DIRECTORY_SEPARATOR.'core'.DS.'class.yourservertype.php';
        //Create VPS Product
        $conf   =   new DirectVPSProduct($params['pid']);
        $conf   ->  saveConfigOptions($_REQUEST['customconfigoption']);
    }
}
**/

