<?php

namespace MGModule\ServerAllocator\libraries\classes;

class MG_Validation
{
    //error handler
    private $error_handler = null;
    
    private $fields = array();
    
    private $input;
    private $data;
    
    //errors
    private $errors = array();
 
    public function setRule($fieldName, $rules)
    {
        //Add Field to field lists
        $this->fields[] = $fieldName;
        
        $ex = explode("|", $rules);
        $arr = array();
        foreach($ex as $rule)
        {
            $exploded = explode(':', $rule);
            
            if(count($exploded) == 1)
            {
                $arr[] = array
                (
                    'rule' =>  $exploded[0],
                    'passed'    => 0
                );
            }
            else
            {
                $rule = $exploded[0];
                unset($exploded[0]);
                
                $arr[] = array
                (
                    'rule' =>  $rule,
                    'vars'  =>  $exploded,
                    'passed'    => 0
                );
            }
        };
        
        $this->data[$fieldName] = array
        (
            'passed'        =>  1,
            'rules'         =>  $arr
        );
    }
    
    public function getErrors() 
    {
        return $this->errors;
    }
    
    public function clearRules()
    {
        $this->data = array();
    }
    
    public function run($input = array())
    {
        if(!$input)
        {
            $input = $_REQUEST;
        }
        
        if(!count($input))
        {
            return false;
        }
        
        if(!array_intersect($this->fields, array_keys($input)))
        {
            return false;
        }
        
        $this->input = $input;
        
        $passed = true;
        foreach($this->data as $fieldName => &$field)
        {
            foreach($field['rules'] as &$rule)
            {
                $func = $rule['rule'];
                if(method_exists($this, $func)) 
                {
                    if(isset($rule['vars']))
                    {
                        $rule['passed'] = (int)call_user_func(array($this, $func), $fieldName, $rule['vars']);
                    }
                    else
                    {
                        $rule['passed'] = (int)call_user_func(array($this, $func), $fieldName);
                    }
               }
               else
               {
                   $rule['passed'] = (int)call_user_func($func, $this->input[$fieldName]);
               }
               
                if(!$rule['passed'])
                {
                    $this->errors[] = array
                    (
                        'field' =>  $fieldName,
                        'rule'  =>  $rule['rule']
                    );
                    $passed = 0;
                    $field['passed'] = 0;
                }
            } 
        }
        
        if(!$passed && $this->error_handler)
        {
            call_user_func($this->error_handler, $this->errors);
        }
        
        return $passed;
    }
    
    public function isValid($field)
    {
        if(!isset($this->data[$field]))
            return true;
        
        return (int)$this->data[$field]['passed'];
    }
    
    private function required($field)
    {
        if(isset($this->input[$field]) && is_array($this->input[$field]))
        {
            return true;
        }
        
        if(strlen(trim($this->input[$field])))
        {
            return true;
        }
        
        return false;
    }
    
    private function email($field)
    {
        if(filter_var($this->input[$field], \FILTER_VALIDATE_EMAIL))
        {
            return true;
        }
        return false;
    }
    
    private function int($field)
    {
        if(filter_var($this->input[$field], \FILTER_VALIDATE_INT))
        {
            return true;
        }
        return false;
    }
    
    private function compare($field, $vars)
    {
        foreach($vars as $var)
        {
            if($this->input[$field] != $this->input[$var])
            {
                return false;
            }
        }
        return true;
    }
    
    private function domain($field)
    {
        $pieces = explode(".",$this->input[$field]);
        foreach($pieces as $piece)
        {
            if (!preg_match('/^[a-z\d][a-z\d-]{0,62}$/i', $piece) || preg_match('/-$/', $piece) )
            {
                return false;
            }
        }
        return true;
    }
    
    private function datetime($field)
    {
        if($this->input[$field] == date( 'Y-m-d H:i:s', strtotime($this->input[$field])))
                return true;
        return false;
    }
    
    private function date($field)
    {
        if($this->input[$field] == date( 'Y-m-d', strtotime($this->input[$field])))
                return true;
        return false;
    }
    
    public function setErrorHandler($error_handler)
    {
        $this->error_handler = $error_handler;
    }
}