<?php
namespace MGModule\ServerAllocator\libraries\classes;

use MGModule\ServerAllocator\libraries\classes as classes;

class Updatetblhosting 
{    
    public function updateByRulePassed($rulespassed, $product, $productid)
    {
        foreach($rulespassed as $rulepassed)
        {
            $servers = classes\GetDataFromDB::getServers($rulepassed['rule'], $product['servertype']);

            $allocatedServer = serverallocatorAllocateServer($servers, $rulepassed['filltype']);
            
            if(!empty($allocatedServer['serverid'])) 
            {
                $this->updateTblHosting($allocatedServer['serverid'], $productid);
                break;
            } 
            else 
            {
                return true;
            }
        }
        return false;
    }

    public function updateByDefault($rulegroup, $product, $productid)
    {
        $dservers  = unserialize($rulegroup['defaultservers']);
        $dserversq = implode(",", (array)$dservers);

        if($dserversq)
        {
            $dserver = classes\GetDataFromDB::getServerId($product['servertype'], $dserversq);
        }

        if(!empty($dserver))
        {
            $this->updateTblHosting($dserver['id'], $productid);
        }
    }

    private function updateTblHosting($serverId, $productid)
    {
        $db = new classes\MG_DB();

        $hosting = $db->row("SELECT `server`, `userid` FROM `tblhosting` WHERE `id` = ?", array($productid));

        $db->query("
        UPDATE `tblhosting`
        SET `server` = ?
        WHERE `id` = ?
        ", array($serverId, $productid));

        logActivity("Modified Product/Service by Server Allocator module. Modified service server from Server ID: {$hosting['server']} to Server ID: {$serverId} - Service ID: {$productid}", $hosting['userid']);
    }
}